package edu.cmu.cs.glacier.useraccounts;


/**
 * User represents a user who has an account on a server.
 */
public class User {
    String username;
    String passwordHash;
    int userID;
    int groupID;

    String[] authorizedFiles; // Files that the user is authorized to access

    public User(String username, String passwordHash, int userID, int groupID, String[] authorizedFiles) {
        this.username = username;
        this.passwordHash = passwordHash;
        this.userID = userID;
        this.groupID = groupID;
        this.authorizedFiles = authorizedFiles;
    }

    public String getUsername() {
        return username;
    }

    public String getPasswordHash() {
        return passwordHash;
    }

    public int getUserID() {
        return userID;
    }

    public int getGroupID() {
        return groupID;
    }

    public String[] getAuthorizedFiles() {
        // TODO; returning null is bogus.
        return null;
    }

    public boolean canChangeAllPasswords() {
        return false;
    }
}
